/****************************************************************************
 *
 *   profile.c: Stores profile info in the Registry 
 *
 *   Vidcap32 Source code
 *
 ***************************************************************************/
#include "stdafx.h"
#include "SpeedDome.h"
#include "ControlDlg.h"
#include "SpeedDomeDoc.h"
#include "SpeedDomeView.h"
#include "vfw.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define KEYNAME     "Software\\Microsoft\\Multimedia Tools\\"
#define ROOTKEY     HKEY_CURRENT_USER

//###################################################################
// read a BOOL flag from the profile, or return default if
// not found.
//###################################################################
BOOL	mmGetProfileFlag(LPSTR appname, LPSTR valuename, BOOL bDefault)
{
char achName[MAX_PATH];
HKEY hkey;
DWORD dwType;
BOOL bValue = bDefault;
DWORD dwData;
unsigned long cbData;


lstrcpy(achName, KEYNAME);
lstrcat(achName, appname);
if (RegOpenKey(ROOTKEY, achName, &hkey) != ERROR_SUCCESS) 
	{	return(bDefault);	}

cbData = (unsigned long )sizeof(dwData);
if (RegQueryValueEx(hkey,valuename,NULL,&dwType,(PBYTE) &dwData,&cbData) == ERROR_SUCCESS) 
	{
    if (dwType == REG_DWORD) 
		{
        if (dwData) 
            bValue = TRUE;
		else
            bValue = FALSE;
        }
	}

RegCloseKey(hkey);

return(bValue);

}


//###################################################################
// write a boolean value to the registry, if it is not the
// same as the default or the value already there
//###################################################################

VOID	mmWriteProfileFlag(LPSTR appname, LPSTR valuename, BOOL bValue, BOOL bDefault)
{
if (mmGetProfileFlag(appname, valuename, bDefault) == bValue) 
	{
    return;
	}

char achName[MAX_PATH];
HKEY hkey;

lstrcpy(achName, KEYNAME);
lstrcat(achName, appname);
if (RegCreateKey(ROOTKEY, achName, &hkey) == ERROR_SUCCESS) 
	{
    RegSetValueEx(hkey,valuename,0,REG_DWORD,
        (PBYTE) &bValue,sizeof(bValue)	     );

    RegCloseKey(hkey);
	}

}

//###################################################################
// read a UINT from the profile, or return default if
// not found.
//###################################################################
UINT	mmGetProfileInt(LPSTR appname, LPSTR valuename, UINT uDefault)
{
char achName[MAX_PATH];
HKEY hkey;
DWORD dwType;
UINT value = uDefault;
DWORD dwData;
unsigned long cbData;


lstrcpy(achName, KEYNAME);
lstrcat(achName, appname);
if (RegOpenKey(ROOTKEY, achName, &hkey) != ERROR_SUCCESS) 
	{
    return(uDefault);
	}

cbData =(unsigned long) sizeof(dwData);
if (RegQueryValueEx(hkey,valuename,NULL,&dwType,(PBYTE) &dwData,
					&cbData) == ERROR_SUCCESS) 
	{
    if (dwType == REG_DWORD) 
		{
        value = (UINT)dwData;
        }
	}

RegCloseKey(hkey);

return(value);
}


//###################################################################
// write a UINT to the profile, if it is not the
// same as the default or the value already there
//###################################################################
VOID	mmWriteProfileInt(LPSTR appname, LPSTR valuename, UINT uValue, UINT uDefault)
{
if (mmGetProfileInt(appname, valuename, uDefault) == uValue) 
	{
    return;
	}

char achName[MAX_PATH];
HKEY hkey;
DWORD dwData = uValue;

lstrcpy(achName, KEYNAME);
lstrcat(achName, appname);
if (RegCreateKey(ROOTKEY, achName, &hkey) == ERROR_SUCCESS) 
	{
    RegSetValueEx(hkey,valuename,0,REG_DWORD,(PBYTE) &dwData,
        sizeof(dwData)    );
    RegCloseKey(hkey);
	}

}


//###################################################################
// read a string from the profile into pResult.
// result is number of bytes written into pResult
//###################################################################
DWORD	mmGetProfileString( LPSTR appname, LPSTR valuename,
					LPSTR pDefault,LPSTR pResult,int cbResult)
{
char achName[MAX_PATH];
HKEY hkey;
DWORD dwType;

lstrcpy(achName, KEYNAME);
lstrcat(achName, appname);
if (RegOpenKey(ROOTKEY, achName, &hkey) == ERROR_SUCCESS) 
	{
    if (RegQueryValueEx(hkey,valuename,NULL, &dwType,(unsigned char*)pResult,
		(unsigned long*)&cbResult) == ERROR_SUCCESS) 
		{
        if (dwType == REG_SZ) 
			{
            // cbResult is set to the size including null
            RegCloseKey(hkey);
            return(cbResult - 1);
            }
		}
    RegCloseKey(hkey);
	}

// if we got here, we didn't find it, or it was the wrong type - return
// the default string
lstrcpy(pResult, pDefault);
return(lstrlen(pDefault));

}


//##################################################################
// write a string to the profile
//##################################################################
VOID	mmWriteProfileString(LPSTR appname, LPSTR valuename, LPSTR pData)
{
char achName[MAX_PATH];
HKEY hkey;

lstrcpy(achName, KEYNAME);
lstrcat(achName, appname);
if (RegCreateKey(ROOTKEY, achName, &hkey) == ERROR_SUCCESS) 
	{
    RegSetValueEx(hkey,valuename,0,REG_SZ,
				(unsigned char*)pData,lstrlen(pData) + 1 );

    RegCloseKey(hkey);
	}

}

//###################################################################
// read binary values from the profile into pResult.
// result is number of bytes written into pResult
//###################################################################
DWORD	mmGetProfileBinary( LPSTR appname,	LPSTR valuename,
							LPVOID pDefault,LPVOID pResult,   // if NULL, return the required size
							int cbSize	)
{
char achName[MAX_PATH];
HKEY hkey;
DWORD dwType;
int cbResult = cbSize;

lstrcpy(achName, KEYNAME);
lstrcat(achName, appname);
if (RegOpenKey(ROOTKEY, achName, &hkey) == ERROR_SUCCESS) 
	{
    if (RegQueryValueEx(hkey,valuename,NULL,&dwType,(unsigned char*)pResult,
				(unsigned long*)&cbResult) == ERROR_SUCCESS) 
		{
        if (dwType == REG_BINARY) 
			{
            // cbResult is the size
            RegCloseKey(hkey);
            return(cbResult);
            }
		}
	RegCloseKey(hkey);
	}

// if we got here, we didn't find it, or it was the wrong type - return
// the default values (use MoveMemory, since src could equal dst)
MoveMemory (pResult, pDefault, cbSize);
return cbSize;

}


//###################################################################
// write binary data to the profile
//###################################################################
VOID	mmWriteProfileBinary(LPSTR appname, LPSTR valuename, LPVOID pData, int cbData)
{
char achName[MAX_PATH];
HKEY hkey;

lstrcpy(achName, KEYNAME);
lstrcat(achName, appname);
if (RegCreateKey(ROOTKEY, achName, &hkey) == ERROR_SUCCESS) 
	{
    RegSetValueEx(hkey,valuename,0,REG_BINARY,
		(unsigned char*)pData,cbData );
    RegCloseKey(hkey);
	}
}

